-- Credits to TOÑO for creating this Cap Display Hud

if unsupported then return end

local function cap_display()
    local metal = get_texture_info("metal")
    local vanish = get_texture_info("vanish")
    local wing = get_texture_info("wing")
	local wmcap = get_texture_info("wmcap")
	local vmcap = get_texture_info("vmcap")
	local wvcap = get_texture_info("wvcap")
    local threecap = get_texture_info("threecap")
    local m = gMarioStates[0]

    if gGlobalSyncTable.modif_fly and (m.flags & (MARIO_VANISH_CAP | MARIO_METAL_CAP)) == 0 then return end
    if gGlobalSyncTable.roundState ~= ROUND_STATE_ACTIVE then return end
    if not eHudVariables.capDisplay then return end

    if (m.flags & (MARIO_WING_CAP | MARIO_METAL_CAP | MARIO_VANISH_CAP)) ~= 0 then
        djui_hud_set_resolution(RESOLUTION_N64);
        djui_hud_set_font(FONT_HUD)
        djui_hud_print_text("=", 35, 204, 1)
        djui_hud_print_text(tostring(math.ceil(m.capTimer/30)), 49, 204, 1)
    end

    if (m.flags & MARIO_METAL_CAP) ~= 0 and (m.flags & MARIO_WING_CAP) ~= 0 and (m.flags & MARIO_VANISH_CAP) ~= 0 then
        djui_hud_render_texture(threecap, 18, 204, 1, 1)
    elseif (m.flags & MARIO_METAL_CAP) ~= 0 and (m.flags & MARIO_WING_CAP) ~= 0 then
        djui_hud_render_texture(wmcap, 18, 204, 1, 1)
    elseif (m.flags & MARIO_METAL_CAP) ~= 0 and (m.flags & MARIO_VANISH_CAP) ~= 0 then
        djui_hud_render_texture(vmcap, 18, 204, 1, 1)
    elseif (m.flags & MARIO_VANISH_CAP) ~= 0 and (m.flags & MARIO_WING_CAP) ~= 0 then
        djui_hud_render_texture(wvcap, 18, 204, 1, 1)
    elseif (m.flags & (MARIO_METAL_CAP)) ~= 0 then
        djui_hud_render_texture(metal, 18, 204, 1, 1)
    elseif(m.flags & (MARIO_VANISH_CAP)) ~= 0 then
        djui_hud_render_texture(vanish, 18, 204, 1, 1)
    elseif (m.flags & (MARIO_WING_CAP)) ~= 0 then
        djui_hud_render_texture(wing, 18, 204, 1, 1)
    end
end

hook_event(HOOK_ON_HUD_RENDER, cap_display)